/*
 * @(#)SimulatedStatement.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.dml.model;

import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * A simulated EntityType.
 *
 * @author  Werner Randelshofer
 * @version 1.0 30. Januar 2004  Created.
 */
public class SimulatedStatement extends AbstractElement implements SimulatedObjectListener {
    /** Creates a new instance. */
    public SimulatedStatement() {
    }
    
    /**
     * Notify all listeners that have registered interest for
     * notification on this event type.
     */
    protected void fireStatementChanged(int index) {
        SimulatedStatementEvent event = null;
        
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==SimulatedStatementListener.class) {
                // Lazily create the event:
                if (event == null)
                    event = new SimulatedStatementEvent(this);
                ((SimulatedStatementListener)listeners[i+1]).statementChanged(event);
            }
        }
    }
    
    public int getSimulatedConcept() {
        return DMLModel.STATEMENT;
    }
    
    public SimulatedStatement clone() {
        SimulatedStatement that = (SimulatedStatement) super.clone();
        return that;
    }
    
    public void write(DOMOutput out) {
    }
    public void read(DOMInput in) {
    }
    public DMLModel getDMLModel() {
        return (DMLModel) getSimulation();
    }
    
    public void objectAdded(SimulatedObjectEvent e) {
    }
    
    public void relationshipAdded(SimulatedObjectEvent e) {
    }
    
    public void relationshipRemoved(SimulatedObjectEvent e) {
    }
    
    public void objectChanged(SimulatedObjectEvent e) {
    }
    
    public void objectRequestRemove(SimulatedObjectEvent e) {
    }
    
    public void objectRemoved(SimulatedObjectEvent e) {
    }
    
    public void addSimulatedStatementListener(SimulatedStatementListener l) {
        listenerList.add(SimulatedStatementListener.class, l);
    }
    
    public void removeSimulatedStatementListener(SimulatedStatementListener l) {
        listenerList.remove(SimulatedStatementListener.class, l);
    }
}
